# dtools sffsdump

This will parse flash dump file, and parse file system (SFFS) structure,
and write files and directories to local PC.

It can support 2 kinds of images: raw flash image or flash logical bin.
Raw flash image is just the image of flash. Logical bin is logic blocks
inside flash, which can be generated by `dtools fbdevdump2` command.

## Example

    dtools sffsdump --flash 0x340000,0x160000,0x8000,0x200 flash.bin dumpdir

The option `--flash` is to specify the flash layout of file system image.
The format is `start,size,eb_size,pb_size`. The option of `start` is flash
offset, not flash address. This parameters should match the flash layout
in target.

> For example, on 8910, the physical address of flash is `0x60000000`.
So, `0x60340000` is the flash address, `0x340000` is the flash offset.

After parsing file system structure, the files and directories inside
flash image will be write under `dumpdir` of local PC. When `dumpdir`
already exists, it will report error, to avoid overwrite.

The path on target will have *mount point* prefix. For example, if the file
system is mounted to `/factory` on target:

|     Path On PC     |   Path On Target    |
| ------------------ | ------------------- |
| `dumpdir/filename` | `/factory/filename` |

## Sub-partitions

> Sub-partition feature is rare used.

When there are multiple sub-partitions on one flash block device, `--offset`
shall be specified, and it is the *starting logical block* of the
sub-partition. For example:

    dtools sffsdump --flash 0x340000,0x160000,0x8000,0x200 \
        --offset 1024 flash.bin dumpdir

## Logical bin

> Logical bin is rare used.

For example:

    dtools sffsdump --blocksize 500 logical.bin dumpdir

The block size is logic block size on flash.
