# vlrsign

`vlrsign`是针对8910平台的签名工具，需要在命令行窗口中运行。

> 以前版本的`vlrsign.exe`在Windows下既支持命令行模式，也支持直接双击的图形界面模式，
> 现在的版本只支持命令行模式，不再支持图形界面模式。

选项说明：

    -v, --version   显示版本信息
    --pw    是使用rsakeygen生成签名秘钥时输入的密码，该密码是读取签名秘钥的口令。
    --pn    是使用rsakeygen生成签名秘钥时输入的产品名称，用于检索签名秘钥。
    --plen  是针对要签名的对象填充的长度。针对8910平台只有boot.img签名时需要填充，而且填充长度是固定的0xbce0。
    --ha    是签名中使用何种hash算法，针对8910平台固定使用Blake2。
    --img   指定签名的文件路径和文件名。
    --out   指定签名完成后的输出文件路径和文件名。

例子：

    vlrsign --pw 12345678 --pn test --plen 0xbce0 --ha Blake2 --img boot.img --out boot.sign.img
    vlrsign --pw 12345678 --pn test --ha Blake2 --img fdl2.img --out fdl2.sign.img
    vlrsign --pw 12345678 --pn test --ha Blake2 --img ap.img --out ap.sign.img

`vlrsign`在执行时需要访问和执行程序相同目录的`key.db`文件，这个文件是由`rsakeygen`生成的，
包含有签名需要的公私钥对的信息。随工具发布的`key.db`只是一个例子，不能在实际产品中使用。在
这个例子中，产品名称是`test`，访问这个产品的公私钥对信息的密码是`12345678`。在实际使用中，
需要把上面例子中的`12345678`替换成实际的密码，`test`替换成实际的产品名。

`vlrsign`产生的签名对于相同的输入和相同的选项，生成的签名是相同的。因此相同的目录执行多次，
生成的带签名的文件是相同的。

# rsakeygen

rsakeygen是签名秘钥生成工具，需要在命令行窗口中运行。

> 以前版本的`rsakeygen.exe`在Windows下既支持命令行模式，也支持直接双击的图形界面模式，
> 现在的版本只支持命令行模式，不再支持图形界面模式。

选项说明：

    -v, --version   显示版本信息
    -pw     输入口令，8位ASCII码，以后vlrsign根据读取签名秘钥时回去校验口令是否正确。
    -pn     输入产品名称，不超过49个ASCII码，以后vlrsign根据输入的产品名称检索相应的签名秘钥。

`rsakeygen`即使输入参数相同，每次产生的公私钥对都是不一样的，产生的`key.db`是不同的。
没有办法产生公钥相同的公私钥对。在实际的产品中，生成的公钥（public key）会烧写到终端
的EFUSE中。

`rsakeygen`生成的公私钥对以加密的方式保存到和执行程序相同的目录下的`key.db`文件，这个
文件包含有敏感信息，因此不能泄露，不能丢失。

* 如果泄露后，其他人可以通过泄露的`key.db`对固件签名，由于公钥和终端EFUSE中的公钥是
  相同的，可以通过secure boot检查；
* 如果丢失后，没有办法再次产生公钥相同的公私钥对，因此就无法对后续的固件进行签名。

当`key.db`已经存在时，`rsakeygen`可以对不同的产品生成公私钥对，但不能对已有的产品再次
生成公私钥对。
